﻿//////////////////////////////////////////////
// Thread.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkTasks
{
	class Scheduler ;
	class Task ;

	struct ThreadInfo ;
}

/// Includes ---------------------------------

// nkTasks
#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------
	
namespace nkTasks
{
	class DLL_TASKS_EXPORT Thread final
	{			
		public :
		
			// Constructor, destructor
			Thread () noexcept ;
			~Thread () ;

			// Getters
			bool getCurrentlyWaiting () const ;

			// Tasks
			void addTask (nkMemory::UniquePtr<Task> task) ;

			// Workflow
			void run () ;

		private :

			// Functions		
			void _asyncProcess () ;

		private :
		
			// Attributes
			nkMemory::UniquePtr<ThreadInfo> _threadInfo ;
	} ;
}